
package w83a.w83aUtilidadesComunes;


import java.util.Date;



public class W83ASolicitudPreavisoDetalles implements java.io.Serializable{

	private static final long serialVersionUID = 1L;

	//Todos los docs adjuntados

	private String CIFNIF;
	private String tipoIdentificacion;
	private String razonSocial;
	private String domicilioCentroTrabajo;
	private String territorioDetalle;
	private String municipio;
	private String codigoPostal;
	private String telefono;
	private String FAX;
	private String email;
	private String CNAE;
	private String territorioSeguridadSocial;
	private String numeroSeguridadSocial;
	private String controlSeguridadSocial;
	private String fechaInicio;
	private String codConvenio;
	private String eleccionParcial;
	private String preavisoGlobal;
	private String numeroCentrosAfectados;
	private String numeroTrabajadores;
	private String administracionEmpresas;
	private String codPromotor;
	private String fechaRegistro;
	private String numerodeRegistro;
	private String codificaciondePreaviso;
	private String identificadorInterno;
	private String observaciones;

	
	private int[] longitud={1,9,1,50,50,2,3,5,15,15,50,4,2,7,2,8,3,1,1,6,6,1,3,8,15,12,15,255};
	private int[] inicio= new int[28];
	
	public int extraerInformacion (String textoPlano,String territorioCabecera) throws W83aException{

		inicio[0]=0;
		int aux=0;
		long auxL=0L;
		Date aux1=null;
		for (int i=1; i<ELEMENTOS_DETALLES;i++){inicio[i]=inicio[i-1]+longitud[i-1];}
		
		int i=1;
		this.CIFNIF=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.tipoIdentificacion=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.tipoIdentificacion));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.tipoIdentificacion");
		}
		this.razonSocial=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.domicilioCentroTrabajo=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.territorioDetalle=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.territorioDetalle));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.territorioDetalle");
		}
		if(Integer.parseInt(W83AStringUtil.eliminarblancos(this.territorioDetalle))!=Integer.parseInt(territorioCabecera)){
			return 2;
			//throw new W83aException("preaviso.error.territorioDetalle.distintoCabecera");
		}
		
		this.municipio=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.municipio));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.municipio");
		}
		this.codigoPostal=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.codigoPostal));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.codigoPostal");
		}
		this.telefono=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.FAX=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.email=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.CNAE=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.territorioSeguridadSocial=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.numeroSeguridadSocial=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.controlSeguridadSocial=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.fechaInicio=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		 try{
				aux1=W83ADateUtils.getDate(this.fechaInicio, "yyyMMdd");
				
			}catch (Exception e){
				return 2;
				//throw new W83aException("preaviso.error.fechaInicio");
			}
		this.codConvenio=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.codConvenio));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.codConvenio");
		}
		this.eleccionParcial=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.preavisoGlobal=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.numeroCentrosAfectados=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.numeroCentrosAfectados));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.numeroCentrosAfectados");
		}
		this.numeroTrabajadores=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.numeroTrabajadores));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.numeroTrabajadores");
		}
		this.administracionEmpresas=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.codPromotor=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.codPromotor));
			
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.codPromotor");
		}
		this.fechaRegistro=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			if (!W83AStringUtil.eliminarblancos(this.fechaRegistro).equals(""))
				{
				aux1=W83ADateUtils.getDate(this.fechaRegistro, "yyyMMdd");
				}
			
		}catch (Exception e){
			return 2;
			//throw new W83aException("preaviso.error.fechaRegistro");
		}
		this.numerodeRegistro=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.codificaciondePreaviso=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		try{
			if (!W83AStringUtil.eliminarblancos(this.codificaciondePreaviso.substring(0, 6)).equals("")){
				aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.codificaciondePreaviso.substring(0, 6)));
			}
			if (!W83AStringUtil.eliminarblancos(this.codificaciondePreaviso.substring(6, 12)).equals("")){
				aux=Integer.parseInt(W83AStringUtil.eliminarblancos(this.codificaciondePreaviso.substring(6, 12)));
			}
		}catch (NumberFormatException e){
			return 2;
			//throw new W83aException("preaviso.error.codificaciondePreaviso");
		}
		this.identificadorInterno=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		this.observaciones=textoPlano.substring(inicio[i],inicio[i]+longitud[i]);i++;
		
		if(aux!=0){aux=0;}
		if(auxL!=0){auxL=0;}
		if(aux1!=null){aux1=null;}
		
	 return 1;	
	}
	
	public String convertiraString(){
		StringBuffer result= new StringBuffer("");
		
		result.append("2");
		result.append(CIFNIF);
		result.append(tipoIdentificacion);
		result.append(razonSocial);
		result.append(domicilioCentroTrabajo);
		result.append(territorioDetalle);
		result.append(municipio);
		result.append(codigoPostal);
		result.append(telefono);
		result.append(FAX);
		result.append(email);
		result.append(CNAE);
		result.append(territorioSeguridadSocial);
		result.append(numeroSeguridadSocial);
		result.append(controlSeguridadSocial);
		result.append(fechaInicio);
		result.append(codConvenio);
		result.append(eleccionParcial);
		result.append(preavisoGlobal);
		result.append(numeroCentrosAfectados);
		result.append(numeroTrabajadores);
		result.append(administracionEmpresas);
		result.append(codPromotor);
		result.append(fechaRegistro);
		result.append(numerodeRegistro);
		result.append(codificaciondePreaviso);
		result.append(identificadorInterno);
		result.append(observaciones).append("\r\n");
		
		return result.toString();
	}
/*
	public String toXML() throws Exception {


		String xml = "<detalle>" + "\r\n" + "\t" 
		+ "<CIFNIF>" + this.CIFNIF + "</CIFNIF>" + "\r\n" + "\t"
		+ "<tipoIdentificacion>" + this.tipoIdentificacion	+ "</tipoIdentificacion>" + "\r\n" + "\t" 
		+ "<razonSocial>" + this.razonSocial + "</razonSocial>"	+ "\r\n" + "\t" 
		+ "<domicilioCentroTrabajo>" + this.domicilioCentroTrabajo + "</domicilioCentroTrabajo>" + "\r\n" + "\t"
		+ "<territorio>" + this.territorioDetalle	+ "</territorio>" + "\r\n" + "\t" 
		+ "<municipio>" + this.municipio + "</municipio>"	+ "\r\n" + "\t" 
		+ "<codigoPostal>" + this.codigoPostal + "</codigoPostal>" + "\r\n" + "\t"
		+ "<telefono>" + this.telefono	+ "</telefono>" + "\r\n" + "\t" 
		+ "<FAX>" + this.FAX + "</FAX>"	+ "\r\n" + "\t" 
		+ "<email>" + this.email + "</email>" + "\r\n" + "\t"
		+ "<CNAE>" + this.CNAE	+ "</CNAE>" + "\r\n" + "\t" 
		+ "<territorioSeguridadSocial>" + this.territorioSeguridadSocial + "</territorioSeguridadSocial>" + "\r\n" + "\t" 
		+ "<numeroSeguridadSocial>" + this.numeroSeguridadSocial + "</numeroSeguridadSocial>" + "\r\n" + "\t"
		+ "<controlSeguridadSocial>" + this.controlSeguridadSocial	+ "</controlSeguridadSocial>" + "\r\n" + "\t" 
		+ "<fechaInicio>" + this.fechaInicio + "</fechaInicio>"	+ "\r\n" + "\t" 
		+ "<codConvenio>" + this.codConvenio + "</codConvenio>" + "\r\n" + "\t"
		+ "<eleccionParcial>" + this.eleccionParcial	+ "</eleccionParcial>" + "\r\n" + "\t" 
		+ "<preavisoGlobal>" + this.preavisoGlobal + "</preavisoGlobal>"	+ "\r\n" + "\t" 
		+ "<numeroCentrosAfectados>" + this.numeroCentrosAfectados + "</numeroCentrosAfectados>" + "\r\n" + "\t"
		+ "<numeroTrabajadores>" + this.numeroTrabajadores	+ "</numeroTrabajadores>" + "\r\n" + "\t" 
		+ "<administracionEmpresas>" + this.administracionEmpresas + "</administracionEmpresas>" + "\r\n" + "\t"
		+ "<codPromotor>" + this.codPromotor	+ "</codPromotor>" + "\r\n" + "\t" 
		+ "<fechaRegistro>" + this.fechaRegistro + "</fechaRegistro>"	+ "\r\n" + "\t" 
		+ "<numerodeRegistro>" + this.numerodeRegistro + "</numerodeRegistro>" + "\r\n" + "\t"
		+ "<codificaciondePreaviso>" + this.codificaciondePreaviso	+ "</codificaciondePreaviso>" + "\r\n" + "\t" 
		+ "<identificadorInterno>" + this.identificadorInterno + "</identificadorInterno>" + "\r\n" + "\t"
		+ "<observaciones>" + this.observaciones + "</observaciones>" + "\r\n" + "\t"
		+ "</detalle>"	+ "\r\n";

		return xml;
	}
*/
	public String getTxtPlano(String idioma) throws Exception {
		
		StringBuffer txtPlano = new StringBuffer(W83aClsConstantes.TRESCIENTOS);
		txtPlano.append("\r\n");
		
		String tit_datosDetalle=W83AI18n.getI18nProperty("w83ai18ntextos","documento.cabecera.datosDetalle", idioma);	
		String tit_CIFNIF=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CIFNIF", idioma);
		String tit_TipoIdentificacion=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.TipoIdentificacion", idioma);
		String tit_RazonSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.RazonSocial", idioma);
		String tit_DomicilioCentroTrabajo=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.DomicilioCentroTrabajo", idioma);
		String tit_TerritorioDetalle=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.TerritorioDetalle", idioma);
		String tit_Municipio=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Municipio", idioma);
		String tit_CodigoPostal=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodigoPostal", idioma);
		String tit_Telefono=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Telefono", idioma);
		String tit_FAX=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.FAX", idioma);
		String tit_Email=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Email", idioma);
		String tit_CNAE=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CNAE", idioma);
		String tit_TerritorioSeguridadSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.TerritorioSeguridadSocial", idioma);
		String tit_NumeroSeguridadSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumeroSeguridadSocial", idioma);
		String tit_ControlSeguridadSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.ControlSeguridadSocial", idioma);
		String tit_FechaInicio=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.FechaInicio", idioma);
		String tit_CodConvenio=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodConvenio", idioma);
		String tit_EleccionParcial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.EleccionParcial", idioma);
		String tit_PreavisoGlobal=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.PreavisoGlobal", idioma);
		String tit_NumeroCentrosAfectados=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumeroCentrosAfectados", idioma);
		String tit_NumeroTrabajadores=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumeroTrabajadores", idioma);
		String tit_AdministracionEmpresas=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.AdministracionEmpresas", idioma);
		String tit_CodPromotor=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodPromotor", idioma);
		String tit_FechaRegistro=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.FechaRegistro", idioma);
		String tit_NumerodeRegistro=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumerodeRegistro", idioma);
		String tit_CodificaciondePreaviso=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodificaciondePreaviso", idioma);
		String tit_IdentificadorInterno=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.IdentificadorInterno", idioma);
		String tit_Observaciones=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Observaciones", idioma);

		txtPlano.append(tit_datosDetalle).append("\r\n");
		txtPlano.append("-----------------------------").append("\r\n");
		txtPlano.append(tit_CIFNIF).append(":").append(this.CIFNIF).append("\r\n");
		txtPlano.append(tit_TipoIdentificacion).append(":").append(this.tipoIdentificacion).append("\r\n");
		txtPlano.append(tit_RazonSocial).append(":").append(this.razonSocial).append("\r\n");
		txtPlano.append(tit_DomicilioCentroTrabajo).append(":").append(this.domicilioCentroTrabajo).append("\r\n");
		txtPlano.append(tit_TerritorioDetalle).append(":").append(this.territorioDetalle).append("\r\n");
		txtPlano.append(tit_Municipio).append(":").append(this.municipio).append("\r\n");
		txtPlano.append(tit_CodigoPostal).append(":").append(this.codigoPostal).append("\r\n");
		txtPlano.append(tit_Telefono).append(":").append(this.telefono).append("\r\n");
		txtPlano.append(tit_FAX).append(":").append(this.FAX).append("\r\n");
		txtPlano.append(tit_Email).append(":").append(this.email).append("\r\n");
		txtPlano.append(tit_CNAE).append(":").append(this.CNAE).append("\r\n");
		txtPlano.append(tit_TerritorioSeguridadSocial).append(":").append(this.territorioSeguridadSocial).append("\r\n");
		txtPlano.append(tit_NumeroSeguridadSocial).append(":").append(this.numeroSeguridadSocial).append("\r\n");
		txtPlano.append(tit_ControlSeguridadSocial).append(":").append(this.controlSeguridadSocial).append("\r\n");
		txtPlano.append(tit_FechaInicio).append(":").append(this.fechaInicio).append("\r\n");
		txtPlano.append(tit_CodConvenio).append(":").append(this.codConvenio).append("\r\n");
		txtPlano.append(tit_EleccionParcial).append(":").append(this.eleccionParcial).append("\r\n");
		txtPlano.append(tit_PreavisoGlobal).append(":").append(this.preavisoGlobal).append("\r\n");
		txtPlano.append(tit_NumeroCentrosAfectados).append(":").append(this.numeroCentrosAfectados).append("\r\n");
		txtPlano.append(tit_NumeroTrabajadores).append(":").append(this.numeroTrabajadores).append("\r\n");
		txtPlano.append(tit_AdministracionEmpresas).append(":").append(this.administracionEmpresas).append("\r\n");
		txtPlano.append(tit_CodPromotor).append(":").append(this.codPromotor).append("\r\n");
		txtPlano.append(tit_FechaRegistro).append(":").append(this.fechaRegistro).append("\r\n");
		txtPlano.append(tit_NumerodeRegistro).append(":").append(this.numerodeRegistro).append("\r\n");
		txtPlano.append(tit_CodificaciondePreaviso).append(":").append(this.codificaciondePreaviso).append("\r\n");
		txtPlano.append(tit_IdentificadorInterno).append(":").append(this.identificadorInterno).append("\r\n");
		txtPlano.append(tit_Observaciones).append(":").append(this.observaciones).append("\r\n");
 
		return txtPlano.toString();
	}
/*	
	public String getXSL(String idioma,String ctxPresentacion) throws Q70GestorMensajesException,
			IllegalArgumentException {

		
	
		String cabeceraEs = "<h1><xsl:value-of select=\"//body/basicInfo/procedureName/description/language[@locale='es']\"/></h1>"
				+ "<h1><xsl:value-of select=\"//body/basicInfo/departmentName/description/language[@locale='es']\"/>. <xsl:value-of select=\"//body/basicInfo/managingUnitName/description/language[@locale='es']\"/></h1>";
		String cabeceraEu = "<h1><xsl:value-of select=\"//body/basicInfo/procedureName/description/language[@locale='eu']\"/></h1>"
				+ "<h1><xsl:value-of select=\"//body/basicInfo/departmentName/description/language[@locale='eu']\"/>. <xsl:value-of select=\"//body/basicInfo/managingUnitName/description/language[@locale='eu']\"/></h1>";
		String cabecera = (idioma.equals("es") ? cabeceraEs : cabeceraEu);

			
			// datos detalle
		String tit_datosDetalle=W83AI18n.getI18nProperty("w83ai18ntextos","documento.cabecera.datosDetalle", idioma);	
		String tit_CIFNIF=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CIFNIF", idioma);
		String tit_TipoIdentificacion=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.TipoIdentificacion", idioma);
		String tit_RazonSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.RazonSocial", idioma);
		String tit_DomicilioCentroTrabajo=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.DomicilioCentroTrabajo", idioma);
		String tit_TerritorioDetalle=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.TerritorioDetalle", idioma);
		String tit_Municipio=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Municipio", idioma);
		String tit_CodigoPostal=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodigoPostal", idioma);
		String tit_Telefono=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Telefono", idioma);
		String tit_FAX=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.FAX", idioma);
		String tit_Email=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Email", idioma);
		String tit_CNAE=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CNAE", idioma);
		String tit_TerritorioSeguridadSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.TerritorioSeguridadSocial", idioma);
		String tit_NumeroSeguridadSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumeroSeguridadSocial", idioma);
		String tit_ControlSeguridadSocial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.ControlSeguridadSocial", idioma);
		String tit_FechaInicio=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.FechaInicio", idioma);
		String tit_CodConvenio=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodConvenio", idioma);
		String tit_EleccionParcial=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.EleccionParcial", idioma);
		String tit_PreavisoGlobal=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.PreavisoGlobal", idioma);
		String tit_NumeroCentrosAfectados=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumeroCentrosAfectados", idioma);
		String tit_NumeroTrabajadores=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumeroTrabajadores", idioma);
		String tit_AdministracionEmpresas=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.AdministracionEmpresas", idioma);
		String tit_CodPromotor=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodPromotor", idioma);
		String tit_FechaRegistro=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.FechaRegistro", idioma);
		String tit_NumerodeRegistro=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.NumerodeRegistro", idioma);
		String tit_CodificaciondePreaviso=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.CodificaciondePreaviso", idioma);
		String tit_IdentificadorInterno=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.IdentificadorInterno", idioma);
		String tit_Observaciones=W83AI18n.getI18nProperty("w83ai18ntextos","documento.detalle.Observaciones", idioma);


					
//					Detalle
		String xsl= "		<h2 class='tkColor1 tkStyleBold toolkitEspVert_b10'>"+tit_datosDetalle+"</h2>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_CIFNIF+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/CIFNIF\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_TipoIdentificacion+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/tipoIdentificacion\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_RazonSocial+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/razonSocial\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_DomicilioCentroTrabajo+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/domicilioCentroTrabajo\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_TerritorioDetalle+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/territorio\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_Municipio+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/municipio\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_CodigoPostal+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/codigoPostal\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_Telefono+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/telefono\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_FAX+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/FAX\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"	
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_Email+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/email\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_CNAE+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/CNAE\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_TerritorioSeguridadSocial+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/territorioSeguridadSocial\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_NumeroSeguridadSocial+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/numeroSeguridadSocial\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_ControlSeguridadSocial+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/controlSeguridadSocial\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_FechaInicio+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/fechaInicio\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_CodConvenio+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/codConvenio\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_EleccionParcial+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/eleccionParcial\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_PreavisoGlobal+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/preavisoGlobal\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_NumeroCentrosAfectados+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/numeroCentrosAfectados\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"	
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_NumeroTrabajadores+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/numeroTrabajadores\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_AdministracionEmpresas+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/administracionEmpresas\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_CodPromotor+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/codPromotor\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_FechaRegistro+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/fechaRegistro\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_NumerodeRegistro+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/numerodeRegistro\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_CodificaciondePreaviso+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/codificaciondePreaviso\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"	
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_IdentificadorInterno+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/identificadorInterno\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>"
					+ "		<div class='toolkitN2'>"
					+ "  			<h3>"+tit_Observaciones+"</h3>"
					+ "			<fieldset>"
					+ "						<label><span class='etiqueta1'><span class='flecha'> </span></span><span class='etiqueta2'><xsl:value-of select=\"//body/detailInfo/detalle/observaciones\"/></span></label>"
					+ "			</fieldset>"
					+ "		</div>";
				

		return xsl;
	}

	*/

		public static final int TAMAO_DETALLE=552;
		
		private static final int ELEMENTOS_DETALLES=28;

		public String getNumeroCentrosAfectados() {
			return numeroCentrosAfectados;
		}
		public String getNumeroTrabajadores() {
			return numeroTrabajadores;
		}
		public String getAdministracionEmpresas() {
			return administracionEmpresas;
		}
		public void setAdministracionEmpresas(String administracionEmpresas) {
			this.administracionEmpresas = administracionEmpresas;
		}
		public String getCIFNIF() {
			return CIFNIF;
		}
		public void setCIFNIF(String cifnif) {
			CIFNIF = cifnif;
		}
		public String getCNAE() {
			return CNAE;
		}
		public void setCNAE(String cnae) {
			CNAE = cnae;
		}
		public String getCodConvenio() {
			return codConvenio;
		}
		public void setCodConvenio(String codConvenio) {
			this.codConvenio = codConvenio;
		}
		public String getCodificaciondePreaviso() {
			return codificaciondePreaviso;
		}
		public void setCodificaciondePreaviso(String codificaciondePreaviso) {
			this.codificaciondePreaviso = codificaciondePreaviso;
		}
		public String getCodigoPostal() {
			return codigoPostal;
		}
		public void setCodigoPostal(String codigoPostal) {
			this.codigoPostal = codigoPostal;
		}
		public String getCodPromotor() {
			return codPromotor;
		}
		public void setCodPromotor(String codPromotor) {
			this.codPromotor = codPromotor;
		}
		public String getControlSeguridadSocial() {
			return controlSeguridadSocial;
		}
		public void setControlSeguridadSocial(String controlSeguridadSocial) {
			this.controlSeguridadSocial = controlSeguridadSocial;
		}
		public String getDomicilioCentroTrabajo() {
			return domicilioCentroTrabajo;
		}
		public void setDomicilioCentroTrabajo(String domicilioCentroTrabajo) {
			this.domicilioCentroTrabajo = domicilioCentroTrabajo;
		}
		public String getEleccionParcial() {
			return eleccionParcial;
		}
		public void setEleccionParcial(String eleccionParcial) {
			this.eleccionParcial = eleccionParcial;
		}
		public String getEmail() {
			return email;
		}
		public void setEmail(String email) {
			this.email = email;
		}
		public String getFAX() {
			return FAX;
		}
		public void setFAX(String fax) {
			FAX = fax;
		}
		public String getFechaInicio() {
			return fechaInicio;
		}
		public void setFechaInicio(String fechaInicio) {
			this.fechaInicio = fechaInicio;
		}
		public String getFechaRegistro() {
			return fechaRegistro;
		}
		public void setFechaRegistro(String fechaRegistro) {
			this.fechaRegistro = fechaRegistro;
		}
		public String getIdentificadorInterno() {
			return identificadorInterno;
		}
		public void setIdentificadorInterno(String identificadorInterno) {
			this.identificadorInterno = identificadorInterno;
		}
		public int[] getInicio() {
			return inicio;
		}
		public void setInicio(int[] inicio) {
			this.inicio = inicio;
		}
		public int[] getLongitud() {
			return longitud;
		}
		public void setLongitud(int[] longitud) {
			this.longitud = longitud;
		}
		public String getMunicipio() {
			return municipio;
		}
		public void setMunicipio(String municipio) {
			this.municipio = municipio;
		}
		public String getNumerodeRegistro() {
			return numerodeRegistro;
		}
		public void setNumerodeRegistro(String numerodeRegistro) {
			this.numerodeRegistro = numerodeRegistro;
		}
		public String getNumeroSeguridadSocial() {
			return numeroSeguridadSocial;
		}
		public void setNumeroSeguridadSocial(String numeroSeguridadSocial) {
			this.numeroSeguridadSocial = numeroSeguridadSocial;
		}
		public String getObservaciones() {
			return observaciones;
		}
		public void setObservaciones(String observaciones) {
			this.observaciones = observaciones;
		}
		public String getPreavisoGlobal() {
			return preavisoGlobal;
		}
		public void setPreavisoGlobal(String preavisoGlobal) {
			this.preavisoGlobal = preavisoGlobal;
		}
		public String getRazonSocial() {
			return razonSocial;
		}
		public void setRazonSocial(String razonSocial) {
			this.razonSocial = razonSocial;
		}
		public String getTelefono() {
			return telefono;
		}
		public void setTelefono(String telefono) {
			this.telefono = telefono;
		}
		public String getTerritorioDetalle() {
			return territorioDetalle;
		}
		public void setTerritorioDetalle(String territorioDetalle) {
			this.territorioDetalle = territorioDetalle;
		}
		public String getTerritorioSeguridadSocial() {
			return territorioSeguridadSocial;
		}
		public void setTerritorioSeguridadSocial(String territorioSeguridadSocial) {
			this.territorioSeguridadSocial = territorioSeguridadSocial;
		}
		public String getTipoIdentificacion() {
			return tipoIdentificacion;
		}
		public void setTipoIdentificacion(String tipoIdentificacion) {
			this.tipoIdentificacion = tipoIdentificacion;
		}
		public void setNumeroCentrosAfectados(String numeroCentrosAfectados) {
			this.numeroCentrosAfectados = numeroCentrosAfectados;
		}
		public void setNumeroTrabajadores(String numeroTrabajadores) {
			this.numeroTrabajadores = numeroTrabajadores;
		}

		
}

